package com.ejie.aa17a.utilidades;

import java.awt.Color;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejie.aa17a.exception.Aa17aPDFException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfException;

/**
 * * Aa17aPDFUtils
 * 
 * @author UDA
 */
public class Aa17aPDFUtils {

	/**
	 * * Constructor Aa17aPDFUtils
	 * 
	 */
	private Aa17aPDFUtils() {
	}

	public final static Font FONT_TITULO_BOLD = new Font(Font.TIMES_ROMAN, 12,
			Font.BOLD, Color.BLACK);
	public final static Font FONT_TITULO = new Font(Font.TIMES_ROMAN, 12,
			Font.NORMAL, Color.BLACK);
	public final static Font FONT_TEXTO_NORMAL = new Font(Font.TIMES_ROMAN, 10,
			Font.NORMAL, Color.BLACK);
	public final static Font FONT_TEXTO_NORMAL_BOLD = new Font(Font.TIMES_ROMAN, 10,
			Font.BOLD, Color.BLACK);
	public final static Font FONT_TEXTO_NORMAL_SUBRAYADO = new Font(Font.TIMES_ROMAN, 10,
			Font.UNDERLINE, Color.BLACK);
	public final static Font FONT_TABLA_CABECERA = new Font(Font.TIMES_ROMAN,
			8, Font.BOLD, Color.BLACK);
	public final static Font FONT_TABLA_TEXTO = new Font(Font.TIMES_ROMAN, 8,
			Font.NORMAL, Color.BLACK);
	public final static Font FONT_TEXTO_PIE = new Font(Font.TIMES_ROMAN, 6,
			Font.NORMAL, Color.BLACK);

	public final static Color TABLA_FONDO_CABECERA = Color.LIGHT_GRAY;
	public final static Color TABLA_FONDO_CELDA = Color.WHITE;

	public final static int ANCHURA_TABLA = 100;
	private static final float INTERLINEADO_CABECERA_TABLA = 8f;
	private static final float INTERLINEADO_CELDA_TABLA = 8f;

	/**
	 * Método que forma una tabla
	 * 
	 * @param tablaPdf
	 *            Table
	 * @param datosTabla
	 *            List<Map<String, Object>>
	 * @param camposReq
	 *            String
	 * @param titulos
	 *            String
	 * @param listaAnchuras
	 *            float[]
	 * @param listaColumnasInterlineado
	 *            String
	 * 
	 * @throws Exception
	 *             e
	 */
	public static void setTabla(Table tablaPdf,
			List<Map<String, Object>> datosTabla, String[] camposReq,
			String[] titulos, float[] listaAnchuras,
			String[] listaColumnasInterlineado) throws Exception {
		try {
			tablaPdf.setWidth(Aa17aPDFUtils.ANCHURA_TABLA);
			tablaPdf.setTableFitsPage(true);
			tablaPdf.setBorder(0);
			tablaPdf.setPadding(2);
			tablaPdf.getDefaultCell().setBorderWidth(1);
			tablaPdf.setWidths(listaAnchuras);

			Aa17aPDFUtils.setCabeceraTabla(tablaPdf, titulos);
			Aa17aPDFUtils.setContenidoTabla(tablaPdf, datosTabla, camposReq,
					listaColumnasInterlineado);
		} catch (Exception e) {
			throw new Exception(e);
		}

	}

	/**
	 * Método que crea la cabecera de la tabla
	 * 
	 * @param tabla
	 *            Table
	 * @param listaTitulos
	 *            String[]
	 * @throws Aa17aPDFException
	 *             e
	 */
	public static void setCabeceraTabla(Table tabla, String[] listaTitulos)
			throws Aa17aPDFException {
		Cell celdaTitulo = null;
		for (int i = 0; i < listaTitulos.length; i++) {
			celdaTitulo = new Cell();//NOPMD - Se debe instanciar el objeto
			celdaTitulo.setVerticalAlignment(Element.ALIGN_CENTER);
			celdaTitulo.setBackgroundColor(Aa17aPDFUtils.TABLA_FONDO_CABECERA);
			Chunk auxTitulo = new Chunk(listaTitulos[i]);//NOPMD - Se debe instanciar el objeto
			auxTitulo.setFont(Aa17aPDFUtils.FONT_TABLA_CABECERA);
			try {
				Paragraph ph = new Paragraph(auxTitulo);//NOPMD - Se debe instanciar el objeto
				ph.setLeading(Aa17aPDFUtils.INTERLINEADO_CABECERA_TABLA);
				celdaTitulo.addElement(ph);
			} catch (Exception e) {
				throw new Aa17aPDFException(e);
			}
			tabla.addCell(celdaTitulo);
		}

	}

	/**
	 * Método que rellena una tabla de un documento.
	 * 
	 * @param tablaPdf
	 *            Table
	 * @param datosPantalla
	 *            List<Map<String, Object>>
	 * @param camposRequeridos
	 *            String
	 * @param camposEspeciales
	 *            String
	 * @throws PdfException
	 *             e
	 */
	public static void setContenidoTabla(Table tablaPdf,
			List<Map<String, Object>> datosPantalla, String[] camposRequeridos,
			String[] camposEspeciales) throws PdfException {
		try {
			List<Map<String, Object>> ArrayListBeansTransformado = null;
			if (null != datosPantalla && datosPantalla.size() > 0) {
				if (datosPantalla.get(0).getClass().toString()
						.indexOf("HashMap") == -1) {
					ArrayListBeansTransformado = Aa17aPDFUtils
							.transformarDatosTabla(datosPantalla,
									camposRequeridos);
				}
				else {
					ArrayListBeansTransformado = datosPantalla;
				}
			}
			else {
				ArrayListBeansTransformado = new ArrayList<Map<String, Object>>();
			}
			Map<String, Object> elementoTabla = null;
			String valorCampo = "";
			boolean condicionSalida = true;

			Paragraph ph = null;
			for (int i = 0; i < ArrayListBeansTransformado.size(); i++) {
				elementoTabla = (Map<String, Object>) ArrayListBeansTransformado
						.get(i);
				for (int j = 0; j < camposRequeridos.length; j++) {
					Cell celda = new Cell();//NOPMD - Se debe instanciar el objeto
					celda.setBackgroundColor(Aa17aPDFUtils.TABLA_FONDO_CELDA);
					try {
						valorCampo = (String) elementoTabla
								.get(camposRequeridos[j]);
					} catch (Exception e) {
						valorCampo = String.valueOf((BigDecimal) elementoTabla
								.get(camposRequeridos[j]));
					}
					if (valorCampo == null) {
						valorCampo = "";
					}
					ph = new Paragraph(new Chunk(valorCampo, Aa17aPDFUtils.FONT_TABLA_TEXTO));//NOPMD - Se debe instanciar el objeto
					condicionSalida = true;
					if (camposEspeciales != null) {
						for (int h = 0; h < camposEspeciales.length; h++) {
							if (camposEspeciales[h].equals(camposRequeridos[j])
									&& condicionSalida) {
								ph.setLeading(Aa17aPDFUtils.INTERLINEADO_CELDA_TABLA);
								condicionSalida = false;
							}
						}
					}
					celda.addElement(ph);
					tablaPdf.addCell(celda);
				}
			}
		} catch (Exception e) {
			throw new PdfException(e);
		}
	}

	/**
	 * Método que devuelve un ArrayList formado por HashMaps a partir del Array
	 * de Beans que se pasa como parametro
	 * 
	 * @param datosTabla
	 *            List<Map<String, Object>> : ArrayList de Beans a transformar
	 * @param propiedadesUtilizadas
	 *            : String compuesto por los campos que se quieren reflejar en
	 *            el HashMap separados por "," y sin espacios
	 * @return List<Map<String, Object>>
	 * @throws PdfException
	 *             e
	 */
	private static List<Map<String, Object>> transformarDatosTabla(
			List<Map<String, Object>> datosTabla, String[] propiedadesUtilizadas)
			throws PdfException {
		List<Map<String, Object>> arrDatosTransformados;
		try {
			arrDatosTransformados = new ArrayList<Map<String, Object>>();
			Map<String, Object> hmDatoTransformado = null;
			for (int i = 0; i < datosTabla.size(); i++) {
				hmDatoTransformado = Aa17aPDFUtils.transformarDato(
						datosTabla.get(i), propiedadesUtilizadas);
				arrDatosTransformados.add(hmDatoTransformado);
			}
		} catch (Exception e) {
			throw new PdfException(e);
		}
		return arrDatosTransformados;
	}

	/**
	 * Método que transforma un bean que se le pase en un HashMap en el que las
	 * claves son las propiedades del bean.
	 * 
	 * @param objeto
	 *            Object : Bean que se quiere tranformar
	 * @param propiedadesUtilizadas
	 *            String : String compuesto por los campos que se quieren
	 *            reflejar en el HashMap separados por "," y sin espacios
	 * @return Map<String, Object>
	 * @throws PdfException
	 *             e
	 */
	private static Map<String, Object> transformarDato(Object objeto,
			String[] propiedadesUtilizadas) throws PdfException {
		Map<String, Object> hmDatoFormado = new HashMap<String, Object>();
		Object[] sinParametros = new Object[0];
		Method[] metodos = objeto.getClass().getMethods();
		try {
			for (int j = 0; j < metodos.length; j++) {
				Method metodo = metodos[j];
				String nombreMetodo = metodos[j].getName();
				for (int i = 0; i < propiedadesUtilizadas.length; i++) {
					// Se pone como condición que empiecen por 'get' o 'is' y
					// que el getParameterTypes sea 0,
					// lo que quiere decir que no se le puedan pasar parámetros
					// al método
					String nombrePropiedadEnMetodo = "";
					if (nombreMetodo.startsWith("get")) {
						nombrePropiedadEnMetodo = nombreMetodo.replaceFirst(
								"get", "");
					}
					else if (nombreMetodo.startsWith("is")) {
						nombrePropiedadEnMetodo = nombreMetodo.replaceFirst(
								"is", "");
					}
					// if
					// ((nombreMetodo.toUpperCase().indexOf(propiedades[i].toUpperCase())!=-1)&&((nombreMetodo.startsWith("get")||nombreMetodo.startsWith("is"))&&
					// metodo.getParameterTypes().length == 0)){
					if ((nombrePropiedadEnMetodo
							.equalsIgnoreCase(propiedadesUtilizadas[i]))
							&& ((nombreMetodo.startsWith("get") || nombreMetodo
									.startsWith("is")) && metodo
									.getParameterTypes().length == 0)) {

						Object obj = metodo.invoke(objeto, sinParametros);
						if (obj instanceof java.lang.String) {
							if (!"".equals(obj)) {
								String strElemento = (String) metodo.invoke(
										objeto, sinParametros);
								hmDatoFormado.put(propiedadesUtilizadas[i],
										strElemento);
							}
							else {
								hmDatoFormado.put(propiedadesUtilizadas[i], "");
							}
						}
						else if (obj instanceof java.util.Date) {
							if (!"".equals(obj)) {
								java.util.Date dElemento = (java.util.Date) obj;
								String fechaTraducida = "";
								fechaTraducida = Aa17aFuncionesComunes
										.formatearFecha(dElemento);
								hmDatoFormado.put(propiedadesUtilizadas[i],
										fechaTraducida);
							}
							else {
								hmDatoFormado.put(propiedadesUtilizadas[i], "");
							}
						}
						else if (obj instanceof java.lang.Boolean) {
							Boolean bElemento = (Boolean) obj;
							if (bElemento.booleanValue()) {
								hmDatoFormado.put(propiedadesUtilizadas[i],
										"SI");
							}
							else {
								hmDatoFormado.put(propiedadesUtilizadas[i],
										"NO");
							}
						}
						else if (obj == null) {
							/**
							 * NOTA: ponemos este ELSE porque cuando un bean
							 * trae una propiedad a NULL (por ejemplo, un String
							 * nulo) no se estaba incluyendo NADA en el HashMap.
							 * Esto causa que al generar un Acta, en la función
							 * setContenidoTabla de esta clase CASCA al intentar
							 * generar un Chunk pasándole un NULL. Creemos que
							 * es mejor que aparezca la propiedad vacía en el
							 * HashMap antes de que no aparezca, para evitar
							 * problemas similares en el futuro.
							 * */
							hmDatoFormado.put(propiedadesUtilizadas[i], "");
						}
					}
				}
			}
		} catch (Exception e) {
			throw new PdfException(e);
		}
		return hmDatoFormado;
	}

}